(function() {
  //    FILE:EventModel
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['Backbone', 'moment', 'models/request/RequestModel'], function(Backbone, Moment, RequestModel) {
    var TimereportModel;
    return TimereportModel = class TimereportModel extends Backbone.Model {
      initialize() {
        //#console.log "Model Timereport initialized"
        return this.reqMdl = new RequestModel();
      }

      get_details_timereport(sessionID) {
        var jsonReq, response, that, xmlReq;
        jsonReq = this.reqMdl.get('JGetTimereport');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', sessionID);
        this.reqMdl.__setNodeValue(jsonReq, 'bookingID', this.get('bookingID'));
        this.reqMdl.__setNodeValue(jsonReq, 'day', this.get('day'));
        xmlReq = this.reqMdl.__getXML(jsonReq);
        that = this;
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj;
          jsonObj = data;
          console.log(jsonObj);
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            return that.set(jsonObj.Result);
          }
        });
        return this;
      }

      init_adhoc_timereport(projObj) {
        return this.set({
          Timereport: projObj
        });
      }

      save_timereport(requestObject, usr) {
        var jsonReq, parent, response, sheet, that, xmlReq;
        that = this;
        parent = 'Timereport';
        jsonReq = this.reqMdl.get('JCommitTimereport');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', requestObject.sessionID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'bookingID', requestObject.bookingID);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'day', requestObject.day);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'dayNote', window.html_entities(requestObject.dayNote));
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'isAdhoc', requestObject.isAdhoc);
        if (requestObject.isAdhoc) {
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'adhocProjectID', requestObject.adhocProjectID);
        }
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'Involved', requestObject.Involved);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'TimeBreak', requestObject.TimeBreak);
        this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'Extra', requestObject.Extras);
        sheet = this.get('Timereport').TravelExpenseSheet;
        if (sheet && !sheet.isNew) {
          _.each(sheet.Expense, function(e) {
            var attr;
            if (window.expense[e.expenseID]) {
              attr = `imagedata${e.expenseID}`;
              //# Avoiding send "data:image/jpeg;base64,"
              return e[attr] = window.expense[e.expenseID].split(',')[1];
            }
          });
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'TravelExpenseSheet', sheet);
        }
        xmlReq = this.reqMdl.__getXML(jsonReq);
        console.log(xmlReq);
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done(function(data, textStatus, jqXHR) {
          var jsonObj, ref;
          jsonObj = data;
          if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
            window.localStorage.clear();
            window.location.href = 'index.html?expired=1';
          }
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            that.set(jsonObj.Result, {
              silent: true
            });
            if (requestObject.isAdhoc || (requestObject.trType === 'ND')) {
              if ((ref = that.collection) != null) {
                ref.get_not_done_timereports(usr);
              }
            }
            return that.trigger('commited');
          } else {
            that.set({
              'errorResult': jsonObj.Result
            }, {
              silent: true
            });
            return that.trigger('commitedError');
          }
        });
        return this;
      }

      initialize_travel_expense(dIn, dOut) {
        var ref, ref1, ref2, ref3, ref4, sheet;
        sheet = this.get('Timereport').TravelExpenseSheet;
        //#INIT NEEDED FOR ADHOC CREATION
        if (!sheet) {
          this.get('Timereport').TravelExpenseSheet = {};
          sheet = this.get('Timereport').TravelExpenseSheet;
        }
        sheet.startDateAndTime = dIn;
        sheet.stopDateAndTime = dOut;
        if ((ref = sheet.breakfastDays) === "" || ref === 0) {
          sheet.breakfastDays = "0";
        }
        if ((ref1 = sheet.lunchDays) === "" || ref1 === 0) {
          sheet.lunchDays = "0";
        }
        if ((ref2 = sheet.dinnerDays) === "" || ref2 === 0) {
          sheet.dinnerDays = "0";
        }
        if ((ref3 = sheet.abroad) === "" || ref3 === 0) {
          sheet.abroad = "0";
        }
        if ((ref4 = sheet.usePerDiem) === "" || ref4 === 0) {
          sheet.usePerDiem = "0";
        }
        sheet.Drive = [];
        sheet.CashAdvance = [];
        return sheet.Expense = [];
      }

      validate_travel_expense(usr) {
        var jsonReq, parent, response, sheet, that, tr, xmlReq;
        that = this;
        tr = this.get('Timereport');
        sheet = tr.TravelExpenseSheet;
        parent = 'TravelExpenseSheet';
        jsonReq = this.reqMdl.get('JValidateTravelExpenseSheet');
        this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
        if (sheet != null ? sheet.travelExpenseSheetID : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'travelExpenseSheetID', sheet.travelExpenseSheetID);
        }
        if (sheet != null ? sheet.note : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'note', sheet.note);
        }
        if (sheet != null ? sheet.destination : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'destination', sheet.destination);
        }
        if (sheet != null ? sheet.breakfastDays : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'breakfastDays', sheet.breakfastDays);
        } else {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'breakfastDays', "0");
        }
        if (sheet != null ? sheet.lunchDays : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'lunchDays', sheet.lunchDays);
        } else {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'lunchDays', "0");
        }
        if (sheet != null ? sheet.dinnerDays : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'dinnerDays', sheet.dinnerDays);
        } else {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'dinnerDays', "0");
        }
        if (sheet != null ? sheet.abroad : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'abroad', sheet.abroad);
        } else {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'abroad', "0");
        }
        if (sheet != null ? sheet.stopDateAndTime : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'stopDateAndTime', sheet.stopDateAndTime);
        }
        if (sheet != null ? sheet.startDateAndTime : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'startDateAndTime', sheet.startDateAndTime);
        }
        if (sheet != null ? sheet.usePerDiem : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'usePerDiem', sheet.usePerDiem);
        } else {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'usePerDiem', "0");
        }
        if (sheet != null ? sheet.cpr : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'cpr', sheet.cpr);
        }
        if (sheet != null ? sheet.Drive : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'Drive', sheet.Drive);
        }
        if (sheet != null ? sheet.CashAdvance : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'CashAdvance', sheet.CashAdvance);
        }
        //# MAKING SURE NOT UPLOADING  IMAGEIFLEDATA THIS PARAMETER IS ONLY FOR RECEIVING IMAGE WE SEND in imagedata (Same as iOS)
        _.each(sheet != null ? sheet.Expense : void 0, function(e) {
          return delete e['imageFileData'];
        });
        if (sheet != null ? sheet.Expense : void 0) {
          this.reqMdl.__setNodeWithParent(jsonReq, parent, 'Expense', sheet.Expense);
        }
        xmlReq = this.reqMdl.__getXML(jsonReq);
        response = this.reqMdl.__send_server_xmlrequest(xmlReq);
        response.done((jsonObj, textStatus, jqXHR) => {
          if (jsonObj != null ? jsonObj.TravelExpenseSheet : void 0) {
            //#UGLY WAY OF FORCING DRIVE,CASHADVANCE,EXPENSE TO BE ALWAYS AN ARRAY EITHER EMPTY or WITH 1 ELEMENT
            if (!jsonObj.TravelExpenseSheet.Drive) {
              jsonObj.TravelExpenseSheet.Drive = [];
            } else {
              if (!_.isArray(jsonObj.TravelExpenseSheet.Drive)) {
                jsonObj.TravelExpenseSheet.Drive = [jsonObj.TravelExpenseSheet.Drive];
              }
            }
            if (!jsonObj.TravelExpenseSheet.CashAdvance) {
              jsonObj.TravelExpenseSheet.CashAdvance = [];
            } else {
              if (!_.isArray(jsonObj.TravelExpenseSheet.CashAdvance)) {
                jsonObj.TravelExpenseSheet.CashAdvance = [jsonObj.TravelExpenseSheet.CashAdvance];
              }
            }
            if (!jsonObj.TravelExpenseSheet.Expense) {
              jsonObj.TravelExpenseSheet.Expense = [];
            } else {
              if (!_.isArray(jsonObj.TravelExpenseSheet.Expense)) {
                jsonObj.TravelExpenseSheet.Expense = [jsonObj.TravelExpenseSheet.Expense];
              }
            }
            tr.TravelExpenseSheet = jsonObj.TravelExpenseSheet;
            that.set({
              'Timereport': tr
            }, {
              silent: true
            });
            return that.trigger('TravelExpenseVerified');
          }
        });
        return this;
      }

      set_travel_per_diem(usr, type, quant) {
        var sheet;
        sheet = this.get('Timereport').TravelExpenseSheet;
        switch (type) {
          case 'breakfast':
            sheet.breakfastDays = quant;
            break;
          case 'lunch':
            sheet.lunchDays = quant;
            break;
          case 'dinner':
            sheet.dinnerDays = quant;
        }
        return this.validate_travel_expense(usr);
      }

    };
  });

}).call(this);
